
/*****************************************************************
 Agent-based Travel Support System
 Copyright (C) 2006 Maciej Gawinecki & Pawel Kaczmarek 

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor,  Boston, MA  
 02110-1301, USA.
 *****************************************************************/

/*****************************************************************************
 * Source code information
 * -----------------------
 * Package            ibspan.tss.um.vocabulary
 * Created            27 sie 2006 04:48
 *****************************************************************************/

// Package
///////////////////////////////////////
package ibspan.tss.um.vocabulary;


// Imports
///////////////////////////////////////
import com.hp.hpl.jena.rdf.model.*;



/**
 * Vocabulary definitions from file:ontology/user-modelling.owl
 * @author Auto-generated by jena.schemagen on 27 sie 2006 04:48
 */
public class UserModellingVocabulary {
    /** <p>The RDF model that holds the vocabulary terms</p> */
    private static Model m_model = ModelFactory.createDefaultModel();
    
    /** <p>The namespace of the vocabulary as a string</p> */
    public static final String NS = "http://www.ibspan.waw.pl/tss/UserModelling#";
    
    /** <p>The namespace of the vocabulary as a string</p>
     *  @see #NS */
    public static String getURI() {return NS;}
    
    /** <p>The namespace of the vocabulary as a resource</p> */
    public static final Resource NAMESPACE = m_model.createResource( NS );
    

    // Vocabulary properties
    ///////////////////////////

    /** <p>Right bound of a set.</p> */
    public static final Property hasRightBound = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasRightBound" );
    
    /** <p>Points the context of this user behaviou. References to the 'actionParams' 
     *  concept from Messaging ontology.</p>
     */
    public static final Property hasContext = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasContext" );
    
    public static final Property hasUserProfileData = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasUserProfileData" );
    
    public static final Property hasWealth = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasWealth" );
    
    /** <p>Describes, who this opinion has been classified by the learning algorithm.</p> */
    public static final Property hasClassification = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasClassification" );
    
    /** <p>Points the type of an action the user performed agains the system.</p> */
    public static final Property hasUserBehaviour = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasUserBehaviour" );
    
    public static final Property hasDress = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasDress" );
    
    public static final Property hasStatisticsEntry = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasStatisticsEntry" );
    
    public static final Property hasWealthSet = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasWealthSet" );
    
    public static final Property hasProfession = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasProfession" );
    
    /** <p>Left bound of a set.</p> */
    public static final Property hasLeftBound = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasLeftBound" );
    
    public static final Property hasStaticticsKey = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasStaticticsKey" );
    
    public static final Property hasDressSet = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasDressSet" );
    
    public static final Property hasExtendedUserBehaviour = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasExtendedUserBehaviour" );
    
    public static final Property hasAgeSet = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasAgeSet" );
    
    public static final Property contains = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#contains" );
    
    public static final Property containsOpinion = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#containsOpinion" );
    
    public static final Property hasOpinions = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasOpinions" );
    
    public static final Property hasStereotypeData = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasStereotypeData" );
    
    public static final Property hasProfessionSet = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasProfessionSet" );
    
    public static final Property hasParameter = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasParameter" );
    
    /** <p>Points the event belonging to this session.</p> */
    public static final Property hasEvent = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasEvent" );
    
    public static final Property hasDomain = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasDomain" );
    
    public static final Property hasAge = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasAge" );
    
    public static final Property ofObject = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#ofObject" );
    
    public static final Property ofResource = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#ofResource" );
    
    public static final Property hasStereotypeID = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasStereotypeID" );
    
    /** <p>Type of an measure (e.g. ordinal), pointed by URI reference to this type.</p> */
    public static final Property ofMeasure = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#ofMeasure" );
    
    /** <p>date of last change of the opinions set</p> */
    public static final Property wasChanged = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#wasChanged" );
    
    public static final Property hasScenarioActionName = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasScenarioActionName" );
    
    /** <p>Unique ID of the Event.</p> */
    public static final Property hasEventID = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasEventID" );
    
    /** <p>Number of events following given key parameters.</p> */
    public static final Property hasCount = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasCount" );
    
    /** <p>Normalized probabilty of interest in a given concept in relation to interest 
     *  of population in this concept.</p>
     */
    public static final Property atNormalizedProbability = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#atNormalizedProbability" );
    
    public static final Property hasQuestionID = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasQuestionID" );
    
    public static final Property hasValue = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasValue" );
    
    /** <p>Concepts being the object of this opinion.</p> */
    public static final Property isAbout = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#isAbout" );
    
    public static final Property hasConceptURI = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasConceptURI" );
    
    /** <p>Describes when the event happened.</p> */
    public static final Property when = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#when" );
    
    public static final Property wasBorn = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#wasBorn" );
    
    public static final Property hasLogin = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasLogin" );
    
    public static final Property hasName = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasName" );
    
    public static final Property hasRate = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasRate" );
    
    /** <p>Rank assigned to Ordinal type variable.</p> */
    public static final Property hasRank = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasRank" );
    
    public static final Property hasShortMessage = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasShortMessage" );
    
    public static final Property hasPassword = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasPassword" );
    
    public static final Property hasTemperature = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasTemperature" );
    
    /** <p>Describes when the session started.</p> */
    public static final Property startedAt = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#startedAt" );
    
    public static final Property hasLongMessage = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasLongMessage" );
    
    /** <p>Individual probability of interest in a given concept.</p> */
    public static final Property atIndividualProbability = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#atIndividualProbability" );
    
    /** <p>Maps abstract value to a real number.</p> */
    public static final Property mapsLinearValue = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#mapsLinearValue" );
    
    /** <p>Unique ID of the Session.</p> */
    public static final Property hasSessionID = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasSessionID" );
    
    /** <p>Inferred probability of interest in a given concept, concluded form dependencies 
     *  between concepts in domain ontology.</p>
     */
    public static final Property atInferredProbability = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#atInferredProbability" );
    
    /** <p>Unique ID of a user</p> */
    public static final Property hasUserID = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasUserID" );
    
    public static final Property hasCardinality = m_model.createProperty( "http://www.ibspan.waw.pl/tss/UserModelling#hasCardinality" );
    

    // Vocabulary classes
    ///////////////////////////

    /** <p>Describes user behaviour together with its context.</p> */
    public static final Resource ExtendedUserBehaviour = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#ExtendedUserBehaviour" );
    
    /** <p>Set containing values of Nominal type measure.</p> */
    public static final Resource NominalSet = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#NominalSet" );
    
    /** <p>Describes domain for Interval measure type in terms of finite set.</p> */
    public static final Resource IntervalDomain = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#IntervalDomain" );
    
    /** <p>Set of person opinions.</p> */
    public static final Resource OpinionSet = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#OpinionSet" );
    
    public static final Resource Parameter = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#Parameter" );
    
    /** <p>Describes age of a person.</p> */
    public static final Resource Age = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#Age" );
    
    /** <p>Represents the context of perfomed user behaviour, such as chosen constrainst 
     *  in search query or URI address of clicked object.</p>
     */
    public static final Resource UserBehaviourContext = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#UserBehaviourContext" );
    
    /** <p>Ordinal measure "extends" nominal type by possibility of ordering values according 
     *  to their rank.</p>
     */
    public static final Resource Ordinal = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#Ordinal" );
    
    /** <p>Defines opinion of a person.</p> */
    public static final Resource Opinion = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#Opinion" );
    
    /** <p>"Extends" concept of measure type to sets consisting of values of a given 
     *  measure type.</p>
     */
    public static final Resource MeasureSet = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#MeasureSet" );
    
    /** <p>Classification of an opinion.</p> */
    public static final Resource Classification = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#Classification" );
    
    /** <p>Data of stereotype "extends" data of profile in the same way, as MeasureSet 
     *  concept "extends" Measure concept.</p>
     */
    public static final Resource StereotypeProfileData = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#StereotypeProfileData" );
    
    /** <p>Internal measures distinguishes between categories, e.g. between professions 
     *  (teacher vs. manager). Elements of this type can be equal or not.</p>
     */
    public static final Resource Nominal = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#Nominal" );
    
    /** <p>Interval measure has values that belong to the linear scale and thus we can 
     *  compute the distance measure directly</p>
     */
    public static final Resource Interval = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#Interval" );
    
    public static final Resource AgeSet = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#AgeSet" );
    
    public static final Resource ProfessionSet = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#ProfessionSet" );
    
    /** <p>Continues finite set with values of Interval measure type.</p> */
    public static final Resource IntervalSet = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#IntervalSet" );
    
    /** <p>Profile of a user or stereotype.</p> */
    public static final Resource Profile = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#Profile" );
    
    /** <p>Profile of a user.</p> */
    public static final Resource UserProfile = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#UserProfile" );
    
    /** <p>Profile of a stereotype.</p> */
    public static final Resource StereotypeProfile = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#StereotypeProfile" );
    
    /** <p>Demographic data describing single person or single stereotype.</p> */
    public static final Resource ProfileData = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#ProfileData" );
    
    /** <p>Gathers a set of Events in single session with authorized (logged in) user.</p> */
    public static final Resource EventSession = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#EventSession" );
    
    public static final Resource WealthSet = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#WealthSet" );
    
    /** <p>Describes potential imperatute of interest (rate) for the givenr object.</p> */
    public static final Resource RatedResult = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#RatedResult" );
    
    public static final Resource ContextParameter = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#ContextParameter" );
    
    /** <p>Defines type of measure for expressing abstract values, that can be mapped 
     *  to mathematical, especially numeric terms (e.g. by they rank or mapped value).</p>
     */
    public static final Resource Measure = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#Measure" );
    
    /** <p>Express wearing style of a person.</p> */
    public static final Resource Dress = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#Dress" );
    
    /** <p>Describes the way user action is remembered and stored in history database.</p> */
    public static final Resource Event = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#Event" );
    
    /** <p>Account of a single register user.</p> */
    public static final Resource User = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#User" );
    
    /** <p>Represents the type of an action the user performed agains the system.</p> */
    public static final Resource UserBehaviour = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#UserBehaviour" );
    
    /** <p>Set containing values of Ordinal type measure.</p> */
    public static final Resource OrdinalSet = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#OrdinalSet" );
    
    /** <p>Express wealth of a person.</p> */
    public static final Resource Wealth = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#Wealth" );
    
    public static final Resource DressSet = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#DressSet" );
    
    /** <p>Describes domain (set of possible values) for a given measure type.</p> */
    public static final Resource MeasureDomain = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#MeasureDomain" );
    
    /** <p>Describes demographic data of single user.</p> */
    public static final Resource UserProfileData = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#UserProfileData" );
    
    /** <p>Describes number of events related to the given user(s), who performed given 
     *  behaviour(s) against given concept(s). If any of mentioned parameters is not 
     *  pointed out, then this statistics reference events with all possible values 
     *  of this parameter.</p>
     */
    public static final Resource StatisticEntry = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#StatisticEntry" );
    
    /** <p>Express profession of a person.</p> */
    public static final Resource Profession = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#Profession" );
    

    // Vocabulary individuals
    ///////////////////////////

    public static final Resource OtherProfession = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#OtherProfession" );
    
    public static final Resource SportyDress = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#SportyDress" );
    
    public static final Resource AverageRich = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#AverageRich" );
    
    public static final Resource VeryRich = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#VeryRich" );
    
    public static final Resource AdvertisingMarketingWorker = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#AdvertisingMarketingWorker" );
    
    public static final Resource ScientistTeacher = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#ScientistTeacher" );
    
    public static final Resource Handworker = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#Handworker" );
    
    /** <p>Defines parameter to point object of user action / behaviour, such a ClickForRestaurantDetailsBehaviour.</p> */
    public static final Resource TargetURI = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#TargetURI" );
    
    public static final Resource AgeMin = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#AgeMin" );
    
    public static final Resource EntrySearchingBehaviour = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#EntrySearchingBehaviour" );
    
    public static final Resource UnemployedJobSeeker = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#UnemployedJobSeeker" );
    
    public static final Resource QueryForRestaurantBehaviour = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#QueryForRestaurantBehaviour" );
    
    public static final Resource ExitSearchingBehaviour = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#ExitSearchingBehaviour" );
    
    public static final Resource SpecialistFreeLancer = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#SpecialistFreeLancer" );
    
    public static final Resource RateRestaurantPositiveBehaviour = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#RateRestaurantPositiveBehaviour" );
    
    public static final Resource ClickForRestaurantDetailsBehaviour = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#ClickForRestaurantDetailsBehaviour" );
    
    public static final Resource ElegantDress = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#ElegantDress" );
    
    public static final Resource ManagerDirector = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#ManagerDirector" );
    
    public static final Resource OtherDress = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#OtherDress" );
    
    public static final Resource NotClassified = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#NotClassified" );
    
    /** <p>This User is only for internal use for storing ID of last registered user.</p> */
    public static final Resource LastUser = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#LastUser" );
    
    /** <p>This event is not only for internal use for storing ID of last event.</p> */
    public static final Resource LastEvent = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#LastEvent" );
    
    public static final Resource Rich = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#Rich" );
    
    public static final Resource ServicesTradeWorker = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#ServicesTradeWorker" );
    
    /** <p>Describes possible values for Age concept.</p> */
    public static final Resource AgeDomain = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#AgeDomain" );
    
    public static final Resource NaturalDress = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#NaturalDress" );
    
    public static final Resource AgeMax = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#AgeMax" );
    
    public static final Resource NotRich = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#NotRich" );
    
    public static final Resource StudentPupil = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#StudentPupil" );
    
    public static final Resource NotInteresting = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#NotInteresting" );
    
    public static final Resource Interesting = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#Interesting" );
    
    public static final Resource PensionerAnnuitant = m_model.createResource( "http://www.ibspan.waw.pl/tss/UserModelling#PensionerAnnuitant" );
    
}

/*
    TODO: Fill in footer
*/

