
/*****************************************************************
 Agent-based Travel Support System
 Copyright (C) 2006 Maciej Gawinecki & Pawel Kaczmarek 

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor,  Boston, MA  
 02110-1301, USA.
 *****************************************************************/

/*****************************************************************************
 * Source code information
 * -----------------------
 * Package            ibspan.tss.domain.vocabulary
 * Created            27 sie 2006 04:45
 *****************************************************************************/

// Package
///////////////////////////////////////
package ibspan.tss.domain.vocabulary;


// Imports
///////////////////////////////////////
import com.hp.hpl.jena.rdf.model.*;



/**
 * Vocabulary definitions from file:ontology/restaurant.owl
 * @author Auto-generated by jena.schemagen on 27 sie 2006 04:45
 */
public class RestaurantVocabulary {
    /** <p>The RDF model that holds the vocabulary terms</p> */
    private static Model m_model = ModelFactory.createDefaultModel();
    
    /** <p>The namespace of the vocabulary as a string</p> */
    public static final String NS = "http://www.ibspan.waw.pl/tss/Restaurant#";
    
    /** <p>The namespace of the vocabulary as a string</p>
     *  @see #NS */
    public static String getURI() {return NS;}
    
    /** <p>The namespace of the vocabulary as a resource</p> */
    public static final Resource NAMESPACE = m_model.createResource( NS );
    

    // Vocabulary properties
    ///////////////////////////

    public static final Property indexPoint = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#indexPoint" );
    
    public static final Property alcohol = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#alcohol" );
    
    public static final Property dress = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#dress" );
    
    public static final Property breakfastPrice = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#breakfastPrice" );
    
    public static final Property lunchPrice = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#lunchPrice" );
    
    public static final Property parking = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#parking" );
    
    public static final Property restaurantService = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#restaurantService" );
    
    public static final Property dinnerPrice = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#dinnerPrice" );
    
    public static final Property accepts = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#accepts" );
    
    public static final Property hasDinerReview = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#hasDinerReview" );
    
    public static final Property locationCategory = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#locationCategory" );
    
    public static final Property accessibility = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#accessibility" );
    
    public static final Property smoking = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#smoking" );
    
    public static final Property feature = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#feature" );
    
    public static final Property reservations = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#reservations" );
    
    public static final Property attractionCategory = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#attractionCategory" );
    
    public static final Property restaurantCategory = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#restaurantCategory" );
    
    public static final Property cuisine = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#cuisine" );
    
    public static final Property phone = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#phone" );
    
    public static final Property streetAddress = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#streetAddress" );
    
    public static final Property fax = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#fax" );
    
    public static final Property locationPath = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#locationPath" );
    
    public static final Property title = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#title" );
    
    public static final Property hours = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#hours" );
    
    public static final Property parsedHours = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#parsedHours" );
    
    public static final Property capacity = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#capacity" );
    
    public static final Property largestParty = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#largestParty" );
    
    public static final Property city = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#city" );
    
    public static final Property neighborhood = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#neighborhood" );
    
    public static final Property accessibilityNotes = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#accessibilityNotes" );
    
    public static final Property clientele = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#clientele" );
    
    public static final Property country = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#country" );
    
    public static final Property reservationURL = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#reservationURL" );
    
    public static final Property crossStreet = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#crossStreet" );
    
    public static final Property menuURL = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#menuURL" );
    
    public static final Property state = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#state" );
    
    public static final Property recommendedDishes = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#recommendedDishes" );
    
    public static final Property zip = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#zip" );
    
    public static final Property deliveryURL = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#deliveryURL" );
    
    public static final Property URL = m_model.createProperty( "http://www.ibspan.waw.pl/tss/Restaurant#URL" );
    

    // Vocabulary classes
    ///////////////////////////

    public static final Resource DressCode = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#DressCode" );
    
    public static final Resource AccessibilityCode = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#AccessibilityCode" );
    
    public static final Resource DinerReview = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#DinerReview" );
    
    public static final Resource ReservationCode = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#ReservationCode" );
    
    public static final Resource AlcoholCode = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#AlcoholCode" );
    
    public static final Resource RestaurantCategoryCode = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#RestaurantCategoryCode" );
    
    public static final Resource ParkingCode = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#ParkingCode" );
    
    public static final Resource Restaurant = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#Restaurant" );
    
    public static final Resource SmokingCode = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SmokingCode" );
    
    public static final Resource FeatureCode = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#FeatureCode" );
    
    public static final Resource RestaurantServiceInfo = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#RestaurantServiceInfo" );
    
    public static final Resource CuisineCode = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CuisineCode" );
    

    // Vocabulary individuals
    ///////////////////////////

    public static final Resource RomanianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#RomanianCuisine" );
    
    public static final Resource ChineseCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#ChineseCuisine" );
    
    public static final Resource Brewery = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#Brewery" );
    
    public static final Resource ReunionCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#ReunionCuisine" );
    
    public static final Resource PhoneAheadSeating = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#PhoneAheadSeating" );
    
    public static final Resource VeganMenu = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#VeganMenu" );
    
    public static final Resource SwedishCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SwedishCuisine" );
    
    public static final Resource JuiceCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#JuiceCuisine" );
    
    public static final Resource Casual = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#Casual" );
    
    public static final Resource DimSumCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#DimSumCuisine" );
    
    public static final Resource SandwichesCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SandwichesCuisine" );
    
    public static final Resource CambodgianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CambodgianCuisine" );
    
    public static final Resource IrishCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#IrishCuisine" );
    
    public static final Resource VegetarianDishes = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#VegetarianDishes" );
    
    public static final Resource FusionCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#FusionCuisine" );
    
    public static final Resource GermanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#GermanCuisine" );
    
    public static final Resource CambodianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CambodianCuisine" );
    
    public static final Resource AsianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#AsianCuisine" );
    
    public static final Resource SeafoodCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SeafoodCuisine" );
    
    public static final Resource InternetAccess = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#InternetAccess" );
    
    public static final Resource Cafe = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#Cafe" );
    
    public static final Resource DressyCasualDress = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#DressyCasualDress" );
    
    public static final Resource HotDogsCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#HotDogsCuisine" );
    
    public static final Resource NorthAfricanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#NorthAfricanCuisine" );
    
    public static final Resource AllPurposeRestaurant = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#AllPurposeRestaurant" );
    
    public static final Resource MalaysianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#MalaysianCuisine" );
    
    public static final Resource ValetParking = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#ValetParking" );
    
    public static final Resource KidFriendly = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#KidFriendly" );
    
    public static final Resource CateringRestaurantService = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CateringRestaurantService" );
    
    public static final Resource PanPacificCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#PanPacificCuisine" );
    
    public static final Resource LargeGroupsOnlyReservations = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#LargeGroupsOnlyReservations" );
    
    public static final Resource SeychellesCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SeychellesCuisine" );
    
    public static final Resource CubanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CubanCuisine" );
    
    public static final Resource RussianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#RussianCuisine" );
    
    public static final Resource CafeRestaurant = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CafeRestaurant" );
    
    public static final Resource Beverage = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#Beverage" );
    
    public static final Resource PersianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#PersianCuisine" );
    
    public static final Resource OwnParkingLot = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#OwnParkingLot" );
    
    public static final Resource FullServiceRestaurantService = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#FullServiceRestaurantService" );
    
    public static final Resource BurgersCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BurgersCuisine" );
    
    public static final Resource BuffetRestaurant = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BuffetRestaurant" );
    
    public static final Resource SoulFoodCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SoulFoodCuisine" );
    
    public static final Resource SudaneseCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SudaneseCuisine" );
    
    public static final Resource SwissCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SwissCuisine" );
    
    public static final Resource ThaiCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#ThaiCuisine" );
    
    public static final Resource AdultEntertainment = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#AdultEntertainment" );
    
    public static final Resource ChileanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#ChileanCuisine" );
    
    public static final Resource SouthAmericanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SouthAmericanCuisine" );
    
    public static final Resource CUICuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CUICuisine" );
    
    public static final Resource FastFood = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#FastFood" );
    
    public static final Resource CasualRestaurant = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CasualRestaurant" );
    
    public static final Resource ContemporaryCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#ContemporaryCuisine" );
    
    public static final Resource NorthAmericanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#NorthAmericanCuisine" );
    
    public static final Resource MiddleEasternCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#MiddleEasternCuisine" );
    
    public static final Resource BritishCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BritishCuisine" );
    
    public static final Resource VegetarianMenu = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#VegetarianMenu" );
    
    public static final Resource UnknownAlkohol = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#UnknownAlkohol" );
    
    public static final Resource BelgianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BelgianCuisine" );
    
    public static final Resource Family = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#Family" );
    
    public static final Resource BiologicalCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BiologicalCuisine" );
    
    public static final Resource WineList = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#WineList" );
    
    public static final Resource BuffetRestaurantService = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BuffetRestaurantService" );
    
    public static final Resource KosherCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#KosherCuisine" );
    
    public static final Resource FixedPriceMealsAtLunc = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#FixedPriceMealsAtLunc" );
    
    public static final Resource Fireplace = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#Fireplace" );
    
    public static final Resource NotAcceptedReservations = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#NotAcceptedReservations" );
    
    public static final Resource IsraeliCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#IsraeliCuisine" );
    
    public static final Resource TunisianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#TunisianCuisine" );
    
    public static final Resource PrivateParties = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#PrivateParties" );
    
    public static final Resource RegionalCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#RegionalCuisine" );
    
    public static final Resource CajunCreoleCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CajunCreoleCuisine" );
    
    public static final Resource CertifiedKosher = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CertifiedKosher" );
    
    public static final Resource TexNexCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#TexNexCuisine" );
    
    public static final Resource BeverageRestaurant = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BeverageRestaurant" );
    
    public static final Resource UnknownAccessible = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#UnknownAccessible" );
    
    public static final Resource PrivateRoomAvailable = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#PrivateRoomAvailable" );
    
    public static final Resource SteaksCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SteaksCuisine" );
    
    public static final Resource FineDiningRestaurant = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#FineDiningRestaurant" );
    
    public static final Resource FamilyRestaurant = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#FamilyRestaurant" );
    
    public static final Resource IndigenousCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#IndigenousCuisine" );
    
    public static final Resource KoreanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#KoreanCuisine" );
    
    public static final Resource MoroccanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#MoroccanCuisine" );
    
    public static final Resource SpanishCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SpanishCuisine" );
    
    public static final Resource ContinentalEuropeanCusine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#ContinentalEuropeanCusine" );
    
    public static final Resource PacificRimCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#PacificRimCuisine" );
    
    public static final Resource BeingYourOwnBeer = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BeingYourOwnBeer" );
    
    public static final Resource FastFoodRestaurant = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#FastFoodRestaurant" );
    
    public static final Resource ItalianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#ItalianCuisine" );
    
    public static final Resource SectionSmoking = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SectionSmoking" );
    
    public static final Resource TurkishCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#TurkishCuisine" );
    
    public static final Resource CreoleCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CreoleCuisine" );
    
    public static final Resource ModernEuropeanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#ModernEuropeanCuisine" );
    
    public static final Resource IndianPakistaniCuis = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#IndianPakistaniCuis" );
    
    public static final Resource TeaHouseCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#TeaHouseCuisine" );
    
    public static final Resource PizzaCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#PizzaCuisine" );
    
    public static final Resource IndianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#IndianCuisine" );
    
    public static final Resource PortugueseCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#PortugueseCuisine" );
    
    public static final Resource NotPermittedSmoking = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#NotPermittedSmoking" );
    
    public static final Resource TapasCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#TapasCuisine" );
    
    public static final Resource VegetarianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#VegetarianCuisine" );
    
    public static final Resource MinorsNotAllowed = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#MinorsNotAllowed" );
    
    public static final Resource FormalRequiredDress = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#FormalRequiredDress" );
    
    public static final Resource BrazilianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BrazilianCuisine" );
    
    public static final Resource JamaicanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#JamaicanCuisine" );
    
    public static final Resource CasualDress = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CasualDress" );
    
    public static final Resource BrasserieCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BrasserieCuisine" );
    
    public static final Resource EasternEuropeanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#EasternEuropeanCuisine" );
    
    public static final Resource ScottishCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#ScottishCuisine" );
    
    public static final Resource OrganicHealthyCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#OrganicHealthyCuisine" );
    
    public static final Resource Upscale = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#Upscale" );
    
    public static final Resource SteakHousesCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SteakHousesCuisine" );
    
    public static final Resource FormalDress = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#FormalDress" );
    
    public static final Resource AmericanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#AmericanCuisine" );
    
    public static final Resource AustrianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#AustrianCuisine" );
    
    public static final Resource DoughnutsCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#DoughnutsCuisine" );
    
    public static final Resource DeliSandwichesCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#DeliSandwichesCuisine" );
    
    public static final Resource UnknownReseravations = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#UnknownReseravations" );
    
    public static final Resource LunchBuffet = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#LunchBuffet" );
    
    public static final Resource RecommendedReservations = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#RecommendedReservations" );
    
    public static final Resource WineTasting = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#WineTasting" );
    
    public static final Resource AustralianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#AustralianCuisine" );
    
    public static final Resource CompletelyAccesible = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CompletelyAccesible" );
    
    public static final Resource Kids = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#Kids" );
    
    public static final Resource NepaleseCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#NepaleseCuisine" );
    
    public static final Resource DriveThrough = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#DriveThrough" );
    
    public static final Resource Cafeteria = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#Cafeteria" );
    
    public static final Resource SpecialMealServicesRestaurantService = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SpecialMealServicesRestaurantService" );
    
    public static final Resource JapaneseCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#JapaneseCuisine" );
    
    public static final Resource RussianUkrainianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#RussianUkrainianCuisine" );
    
    public static final Resource TakeOutRestaurantService = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#TakeOutRestaurantService" );
    
    public static final Resource AfricanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#AfricanCuisine" );
    
    public static final Resource DinnerBuffet = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#DinnerBuffet" );
    
    public static final Resource SouthernCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SouthernCuisine" );
    
    public static final Resource NiceView = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#NiceView" );
    
    public static final Resource NoAlcoholServed = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#NoAlcoholServed" );
    
    public static final Resource GameCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#GameCuisine" );
    
    public static final Resource FilipinoCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#FilipinoCuisine" );
    
    public static final Resource ArmenianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#ArmenianCuisine" );
    
    public static final Resource OtherCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#OtherCuisine" );
    
    public static final Resource StreetParking = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#StreetParking" );
    
    public static final Resource TrendyCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#TrendyCuisine" );
    
    public static final Resource CanadianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CanadianCuisine" );
    
    public static final Resource AcceptedReservations = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#AcceptedReservations" );
    
    public static final Resource UpscaleRestaurant = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#UpscaleRestaurant" );
    
    public static final Resource LargeGroupsOk = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#LargeGroupsOk" );
    
    public static final Resource SoutheastAsianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SoutheastAsianCuisine" );
    
    public static final Resource UnknownDress = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#UnknownDress" );
    
    public static final Resource JewishCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#JewishCuisine" );
    
    public static final Resource PublicTransitAccessible = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#PublicTransitAccessible" );
    
    public static final Resource Entertainment = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#Entertainment" );
    
    public static final Resource EclecticCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#EclecticCuisine" );
    
    public static final Resource PartiallyAccessible = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#PartiallyAccessible" );
    
    public static final Resource UnknownSmoking = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#UnknownSmoking" );
    
    public static final Resource RoomServiceRestaurantService = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#RoomServiceRestaurantService" );
    
    public static final Resource LargePrintMenu = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#LargePrintMenu" );
    
    public static final Resource HamburgerCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#HamburgerCuisine" );
    
    public static final Resource ChopeHouseCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#ChopeHouseCuisine" );
    
    public static final Resource Winery = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#Winery" );
    
    public static final Resource DinerCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#DinerCuisine" );
    
    public static final Resource RequiredReservations = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#RequiredReservations" );
    
    public static final Resource PolynesianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#PolynesianCuisine" );
    
    public static final Resource FineDining = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#FineDining" );
    
    public static final Resource ExtensiveWineList = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#ExtensiveWineList" );
    
    public static final Resource EnglishCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#EnglishCuisine" );
    
    public static final Resource MealsToGoRestaurantService = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#MealsToGoRestaurantService" );
    
    public static final Resource SaladBar = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SaladBar" );
    
    public static final Resource BarbecueCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BarbecueCuisine" );
    
    public static final Resource TibetanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#TibetanCuisine" );
    
    public static final Resource BarPubBreweryCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BarPubBreweryCuisine" );
    
    public static final Resource InternationalCuisin = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#InternationalCuisin" );
    
    public static final Resource Delivery = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#Delivery" );
    
    public static final Resource BreakfastBrunchCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BreakfastBrunchCuisine" );
    
    public static final Resource CafeteriaCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CafeteriaCuisine" );
    
    public static final Resource GreekCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#GreekCuisine" );
    
    public static final Resource CookedToOrderRestaurantService = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CookedToOrderRestaurantService" );
    
    public static final Resource NotAccessible = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#NotAccessible" );
    
    public static final Resource DessertIceCreamCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#DessertIceCreamCuisine" );
    
    public static final Resource FineDiningRestaurantService = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#FineDiningRestaurantService" );
    
    public static final Resource FishAndChipsCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#FishAndChipsCuisine" );
    
    public static final Resource BeingYourOwnWine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BeingYourOwnWine" );
    
    public static final Resource OffsiteCatering = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#OffsiteCatering" );
    
    public static final Resource PayParking = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#PayParking" );
    
    public static final Resource FixedPriceMealsAtDinn = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#FixedPriceMealsAtDinn" );
    
    public static final Resource FamilyCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#FamilyCuisine" );
    
    public static final Resource WineBeer = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#WineBeer" );
    
    public static final Resource MongolianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#MongolianCuisine" );
    
    public static final Resource DanishCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#DanishCuisine" );
    
    public static final Resource BagelsCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BagelsCuisine" );
    
    public static final Resource ScandinavianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#ScandinavianCuisine" );
    
    public static final Resource OnlyAtBarSmoking = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#OnlyAtBarSmoking" );
    
    public static final Resource CaliforniaCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CaliforniaCuisine" );
    
    public static final Resource PeruvianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#PeruvianCuisine" );
    
    public static final Resource PermittedSmoking = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#PermittedSmoking" );
    
    public static final Resource KioskRestaurant = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#KioskRestaurant" );
    
    public static final Resource FineDiningCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#FineDiningCuisine" );
    
    public static final Resource SundayBrunch = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SundayBrunch" );
    
    public static final Resource CentralEuropeanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CentralEuropeanCuisine" );
    
    public static final Resource AfghanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#AfghanCuisine" );
    
    public static final Resource LatinAmericanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#LatinAmericanCuisine" );
    
    public static final Resource CaribbeanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CaribbeanCuisine" );
    
    public static final Resource TakeOutRestaurant = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#TakeOutRestaurant" );
    
    public static final Resource MediterraneanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#MediterraneanCuisine" );
    
    public static final Resource BrailleMenu = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BrailleMenu" );
    
    public static final Resource BakeryCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BakeryCuisine" );
    
    public static final Resource CafeteriaRestaurant = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CafeteriaRestaurant" );
    
    public static final Resource CafeCoffeeShopCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CafeCoffeeShopCuisine" );
    
    public static final Resource VeganDishes = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#VeganDishes" );
    
    public static final Resource BurmeseCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BurmeseCuisine" );
    
    public static final Resource AllPurpose = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#AllPurpose" );
    
    public static final Resource ArgentineanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#ArgentineanCuisine" );
    
    public static final Resource SushiCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SushiCuisine" );
    
    public static final Resource HawaiianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#HawaiianCuisine" );
    
    public static final Resource DutchBelgianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#DutchBelgianCuisine" );
    
    public static final Resource LebaneseCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#LebaneseCuisine" );
    
    public static final Resource IndonesianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#IndonesianCuisine" );
    
    public static final Resource TastingMenu = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#TastingMenu" );
    
    public static final Resource FastFoodCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#FastFoodCuisine" );
    
    public static final Resource IcecreamParlourCuis = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#IcecreamParlourCuis" );
    
    public static final Resource CatalanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CatalanCuisine" );
    
    public static final Resource NoLocalParking = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#NoLocalParking" );
    
    public static final Resource Buffet = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#Buffet" );
    
    public static final Resource CasualDiningRestaurantService = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#CasualDiningRestaurantService" );
    
    public static final Resource SardinianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SardinianCuisine" );
    
    public static final Resource SouthwesternCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SouthwesternCuisine" );
    
    public static final Resource SoupCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SoupCuisine" );
    
    public static final Resource FinnishCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#FinnishCuisine" );
    
    public static final Resource SaharanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SaharanCuisine" );
    
    public static final Resource EnglishLanguageMenu = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#EnglishLanguageMenu" );
    
    public static final Resource VietnameseCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#VietnameseCuisine" );
    
    public static final Resource Takeout = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#Takeout" );
    
    public static final Resource Outdoor = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#Outdoor" );
    
    public static final Resource Conservatory = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#Conservatory" );
    
    public static final Resource PolishCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#PolishCuisine" );
    
    public static final Resource Kiosk = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#Kiosk" );
    
    public static final Resource EuropeanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#EuropeanCuisine" );
    
    public static final Resource BasqueCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BasqueCuisine" );
    
    public static final Resource HungarianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#HungarianCuisine" );
    
    public static final Resource PacificNorthwestCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#PacificNorthwestCuisine" );
    
    public static final Resource FullBar = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#FullBar" );
    
    public static final Resource SelfServiceRestaurantService = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SelfServiceRestaurantService" );
    
    public static final Resource BeerTasting = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BeerTasting" );
    
    public static final Resource MexicanCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#MexicanCuisine" );
    
    public static final Resource EthiopianCuisine = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#EthiopianCuisine" );
    
    public static final Resource Halal = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#Halal" );
    
    public static final Resource SenorMenu = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#SenorMenu" );
    
    public static final Resource BreakfastBuffet = m_model.createResource( "http://www.ibspan.waw.pl/tss/Restaurant#BreakfastBuffet" );
    
}

/*
    TODO: Fill in footer
*/

