
/*****************************************************************
 Agent-based Travel Support System
 Copyright (C) 2006 Maciej Gawinecki & Pawel Kaczmarek 

 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 2
 of the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 51 Franklin Street, Fifth Floor,  Boston, MA  
 02110-1301, USA.
 *****************************************************************/

/*****************************************************************************
 * Source code information
 * -----------------------
 * Package            ibspan.tss.domain.vocabulary
 * Created            27 sie 2006 04:45
 *****************************************************************************/

// Package
///////////////////////////////////////
package ibspan.tss.domain.vocabulary;


// Imports
///////////////////////////////////////
import com.hp.hpl.jena.rdf.model.*;



/**
 * Vocabulary definitions from file:ontology/money.owl
 * @author Auto-generated by jena.schemagen on 27 sie 2006 04:45
 */
public class MoneyVocabulary {
    /** <p>The RDF model that holds the vocabulary terms</p> */
    private static Model m_model = ModelFactory.createDefaultModel();
    
    /** <p>The namespace of the vocabulary as a string</p> */
    public static final String NS = "http://www.ibspan.waw.pl/tss/Money#";
    
    /** <p>The namespace of the vocabulary as a string</p>
     *  @see #NS */
    public static String getURI() {return NS;}
    
    /** <p>The namespace of the vocabulary as a resource</p> */
    public static final Resource NAMESPACE = m_model.createResource( NS );
    

    // Vocabulary properties
    ///////////////////////////


    // Vocabulary classes
    ///////////////////////////

    public static final Resource MeanOfPayment = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#MeanOfPayment" );
    
    public static final Resource FuzzyPriceCode = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#FuzzyPriceCode" );
    

    // Vocabulary individuals
    ///////////////////////////

    public static final Resource JCBCard = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#JCBCard" );
    
    public static final Resource DirectBill = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#DirectBill" );
    
    public static final Resource CarteBlancheCard = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#CarteBlancheCard" );
    
    public static final Resource ChargeCard = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#ChargeCard" );
    
    public static final Resource Barter = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#Barter" );
    
    public static final Resource Redemption = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#Redemption" );
    
    public static final Resource AmericanExpressCard = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#AmericanExpressCard" );
    
    public static final Resource VisaCard = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#VisaCard" );
    
    public static final Resource DiscoverCard = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#DiscoverCard" );
    
    public static final Resource MoneyOrder = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#MoneyOrder" );
    
    public static final Resource BankCard = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#BankCard" );
    
    public static final Resource Deposit = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#Deposit" );
    
    public static final Resource Voucher = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#Voucher" );
    
    public static final Resource CentralBill = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#CentralBill" );
    
    public static final Resource CreditCard = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#CreditCard" );
    
    public static final Resource Price = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#Price" );
    
    public static final Resource Inexpensive = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#Inexpensive" );
    
    public static final Resource PersonalCheck = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#PersonalCheck" );
    
    public static final Resource Coupon = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#Coupon" );
    
    public static final Resource DebitCard = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#DebitCard" );
    
    public static final Resource PrePay = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#PrePay" );
    
    public static final Resource Expensive = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#Expensive" );
    
    public static final Resource Cash = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#Cash" );
    
    public static final Resource VeryExpensive = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#VeryExpensive" );
    
    public static final Resource GiftCertificates = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#GiftCertificates" );
    
    public static final Resource BusinessAccount = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#BusinessAccount" );
    
    public static final Resource BusinessCheck = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#BusinessCheck" );
    
    public static final Resource DinersClubCard = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#DinersClubCard" );
    
    public static final Resource VeryCheap = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#VeryCheap" );
    
    public static final Resource BankCheck = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#BankCheck" );
    
    public static final Resource MasterCardEuroCard = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#MasterCardEuroCard" );
    
    public static final Resource EnRouteCard = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#EnRouteCard" );
    
    public static final Resource Moderate = m_model.createResource( "http://www.ibspan.waw.pl/tss/Money#Moderate" );
    
}

/*
    TODO: Fill in footer
*/

